function ecg=meshecgraph(f,gf,bins)
% MESHECGRAPH EC-Graph feature calculation for a triangular mesh object.
%   ECG = MESHECGRAPH(F,GF,BINS) calculates the EC-Graph vector for the triangular
%   mesh defined by the matrix F (mx3) with the function GF defined over the faces,
%   using the threshold values in BINS. Not that the result does not depend on the
%   mesh vertices (V).
%   ECG(i) corresponds to EC(GF(F)>=bins(i)).
%
%   See demoECGMesh.m for a usage demo.
% 
% For questions, please contact eitan.richardson@gmail.com
%
% When using this code, please refer to:
%   Richardson, Eitan, and Michael Werman. 
%   "Efficient classification using the Euler characteristic." 
%   Pattern Recognition Letters 49 (2014): 99-106.
%   http://www.sciencedirect.com/science/article/pii/S0167865514002050


% Create ge (function over edges) = max gf over faces containing e
e0=sort([f(:,[1 2]) ; f(:,[2 3]) ; f(:,[1 3])],2);
ge0=[gf ; gf ; gf];
ges=accumarray(e0,ge0,[],@max,[],true);
[~, ~, ge]=find(ges);
clear('e0','ge0','ges');

% Create gv (function over vertices) = max gf over faces containing v
gv=accumarray(f(:),[gf;gf;gf],[],@max);

% Count accumulative histograms
hf=histc(gf,bins); hf=cumsum(hf(end:-1:1)); hf=hf(end:-1:1);
he=histc(ge,bins); he=cumsum(he(end:-1:1)); he=he(end:-1:1);
hv=histc(gv,bins); hv=cumsum(hv(end:-1:1)); hv=hv(end:-1:1);

% Calculate Euler Characteritics
ecg=hv-he+hf;

end
