% Input: 
%        I: nxmxl matrix (e.g. B&W volumetric image)
%        bins: threshold values
% output: ec: Euler Characteristic values
function ec=fastVolImEc(I,bins)
[n,m,l]=size(I);

% Function over cubes (voxels)
gc=I(:);

% Create a zero-padded version
Ipad=zeros(n+2,m+2,l+2);
Ipad(2:end-1,2:end-1,2:end-1)=I;

% Calculate function over faces = max function over containing cubes
If1=max(Ipad(1:end-1,2:end-1,2:end-1),Ipad(2:end,2:end-1,2:end-1));
If2=max(Ipad(2:end-1,1:end-1,2:end-1),Ipad(2:end-1,2:end,2:end-1));
If3=max(Ipad(2:end-1,2:end-1,1:end-1),Ipad(2:end-1,2:end-1,2:end));
gf=[If1(:);If2(:);If3(:)];

% Calculate function over edges = max function over containing cobes
Ie1=max(Ipad(:,1:end-1,2:end-1),Ipad(:,2:end,2:end-1));
Ie1=max(Ie1(1:end-1,:,:),Ie1(2:end,:,:));
Ie2=max(Ipad(2:end-1,:,1:end-1),Ipad(2:end-1,:,2:end));
Ie2=max(Ie2(:,1:end-1,:),Ie2(:,2:end,:));
Ie3=max(Ipad(:,2:end-1,1:end-1),Ipad(:,2:end-1,2:end));
Ie3=max(Ie3(1:end-1,:,:),Ie3(2:end,:,:));
ge=[Ie1(:);Ie2(:);Ie3(:)];

% Calculate function over vertices = max function over containing cubes
Iv=max(Ipad(:,1:end-1,:),Ipad(:,2:end,:));
Iv=max(Iv(1:end-1,:,:),Iv(2:end,:,:));
Iv=max(Iv(:,:,1:end-1),Iv(:,:,2:end));
gv=Iv(:);

% Count accumulative histograms
bins=[bins inf];
hc=histc(gc,bins); hc=cumsum(hc(end-1:-1:1)); hc=hc(end:-1:1);
hf=histc(gf,bins); hf=cumsum(hf(end-1:-1:1)); hf=hf(end:-1:1);
he=histc(ge,bins); he=cumsum(he(end-1:-1:1)); he=he(end:-1:1);
hv=histc(gv,bins); hv=cumsum(hv(end-1:-1:1)); hv=hv(end:-1:1);
% Calculate Euler Characteritics
ec=hv-he+hf-hc;
end
