% EC-Graph feature calculation for a single-channel image.
% help imecgraph for more info.
%
% When using this code, please refer to:
%   Richardson, Eitan, and Michael Werman. 
%   "Efficient classification using the Euler characteristic." 
%   Pattern Recognition Letters 49 (2014): 99-106.
%   http://www.sciencedirect.com/science/article/pii/S0167865514002050

close all; clear;

N = 64; % Number of threshold values
imageName = 'canoe.tif';
%imageName = 'cameraman.tif';
%imageName = 'fabric.png';

% Read an input image and convert to grayscale
I = im2double(imread(imageName));
if size(I,3)>1
    I = rgb2gray(I);
end
figure, imshow(I); title(imageName); movegui('northwest');

% Define a N-bin threshold edges (last edge will be set to Inf)
T = 0:1/N:0.999;

tic;
%% Calculatet he EC-Graph descriptor vector
ecg = imecgraph(I,T);

%%
et=toc;
fprintf('EC-Graph calculation of %d values for a %dx%d image took %f sec.\n',...
    length(ecg), size(I,1),size(I,2),et);

% Plot the result
figure,plot(T,ecg,'.-'); movegui('northeast');
xlabel('Threshold Value'); ylabel('Euler Characteristic'); 
title(['EC-Graph Descriptor for ' imageName]); grid on;

% Show the thresholding result
figure; movegui('south');
for i=1:length(T)
    imshow(I>=T(i));
    title(sprintf('t=%0.3f, EC=%d',T(i),ecg(i)));
    pause(0.1);
end

