/* Generated by re2c 0.13.5 */
/*
  +----------------------------------------------------------------------+
  | PHP Version 7                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2016 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition

#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);
	
std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if (YYGETCONDITION() < 1) {
			goto yyc_JS;
		} else {
			if (YYGETCONDITION() < 2) {
				goto yyc_STR_P1;
			} else {
				goto yyc_STR_P2;
			}
		}
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0, 128,   0,   0,   0, 128,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,  64,  64,  64,  64,  64,  64,  64, 
				 64,  64,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};

			yych = *YYCURSOR;
			if (yych <= ']') {
				if (yych <= '"') {
					if (yych <= '\f') {
						if (yych <= 0x08) {
							if (yych >= 0x01) goto yy4;
						} else {
							if (yych <= '\t') goto yy6;
							if (yych <= '\n') goto yy8;
							goto yy4;
						}
					} else {
						if (yych <= 0x1F) {
							if (yych <= '\r') goto yy9;
							goto yy4;
						} else {
							if (yych <= ' ') goto yy10;
							if (yych <= '!') goto yy11;
							goto yy13;
						}
					}
				} else {
					if (yych <= '0') {
						if (yych <= ',') {
							if (yych <= '+') goto yy11;
							goto yy15;
						} else {
							if (yych <= '-') goto yy17;
							if (yych <= '/') goto yy11;
							goto yy18;
						}
					} else {
						if (yych <= 'Z') {
							if (yych <= '9') goto yy20;
							if (yych <= ':') goto yy21;
							goto yy11;
						} else {
							if (yych <= '[') goto yy23;
							if (yych <= '\\') goto yy11;
							goto yy25;
						}
					}
				}
			} else {
				if (yych <= '}') {
					if (yych <= 's') {
						if (yych <= 'f') {
							if (yych <= 'e') goto yy11;
							goto yy27;
						} else {
							if (yych == 'n') goto yy28;
							goto yy11;
						}
					} else {
						if (yych <= 'z') {
							if (yych <= 't') goto yy29;
							goto yy11;
						} else {
							if (yych <= '{') goto yy30;
							if (yych <= '|') goto yy11;
							goto yy32;
						}
					}
				} else {
					if (yych <= 0xEC) {
						if (yych <= 0xC1) {
							if (yych <= 0x7F) goto yy11;
							goto yy34;
						} else {
							if (yych <= 0xDF) goto yy36;
							if (yych <= 0xE0) goto yy37;
							goto yy38;
						}
					} else {
						if (yych <= 0xF0) {
							if (yych <= 0xED) goto yy39;
							if (yych <= 0xEF) goto yy40;
							goto yy41;
						} else {
							if (yych <= 0xF3) goto yy42;
							if (yych <= 0xF4) goto yy43;
							goto yy34;
						}
					}
				}
			}
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
			return PHP_JSON_T_ERROR;
		}
	}
yy4:
			++YYCURSOR;
			{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy6:
			++YYCURSOR;
			yych = *YYCURSOR;
			goto yy81;
yy7:
			{ goto std; }
yy8:
			yych = *++YYCURSOR;
			goto yy7;
yy9:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy82;
			goto yy81;
yy10:
			yych = *++YYCURSOR;
			goto yy81;
yy11:
			++YYCURSOR;
yy12:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy13:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		PHP_JSON_CONDITION_SET(STR_P1);
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy15:
			++YYCURSOR;
			{ return ','; }
yy17:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy12;
			if (yych <= '0') goto yy79;
			if (yych <= '9') goto yy69;
			goto yy12;
yy18:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy71;
			} else {
				if (yych <= 'E') goto yy72;
				if (yych == 'e') goto yy72;
			}
yy19:
			{
		zend_bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy20:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			goto yy70;
yy21:
			++YYCURSOR;
			{ return ':'; }
yy23:
			++YYCURSOR;
			{ return '['; }
yy25:
			++YYCURSOR;
			{ return ']'; }
yy27:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy64;
			goto yy12;
yy28:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy60;
			goto yy12;
yy29:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy56;
			goto yy12;
yy30:
			++YYCURSOR;
			{ return '{'; }
yy32:
			++YYCURSOR;
			{ return '}'; }
yy34:
			++YYCURSOR;
yy35:
			{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy36:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy35;
			if (yych <= 0xBF) goto yy47;
			goto yy35;
yy37:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x9F) goto yy35;
			if (yych <= 0xBF) goto yy55;
			goto yy35;
yy38:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy35;
			if (yych <= 0xBF) goto yy54;
			goto yy35;
yy39:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy35;
			if (yych <= 0x9F) goto yy53;
			goto yy35;
yy40:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy35;
			if (yych <= 0xBF) goto yy52;
			goto yy35;
yy41:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x8F) goto yy35;
			if (yych <= 0xBF) goto yy50;
			goto yy35;
yy42:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy35;
			if (yych <= 0xBF) goto yy48;
			goto yy35;
yy43:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy35;
			if (yych >= 0x90) goto yy35;
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy46;
yy45:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy19;
				} else {
					goto yy12;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy35;
				} else {
					goto yy76;
				}
			}
yy46:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych >= 0xC0) goto yy45;
yy47:
			yych = *++YYCURSOR;
			goto yy12;
yy48:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych >= 0xC0) goto yy45;
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy50:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych >= 0xC0) goto yy45;
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy52:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy53:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy54:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy55:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy47;
			goto yy45;
yy56:
			yych = *++YYCURSOR;
			if (yych != 'u') goto yy45;
			yych = *++YYCURSOR;
			if (yych != 'e') goto yy45;
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy60:
			yych = *++YYCURSOR;
			if (yych != 'l') goto yy45;
			yych = *++YYCURSOR;
			if (yych != 'l') goto yy45;
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy64:
			yych = *++YYCURSOR;
			if (yych != 'l') goto yy45;
			yych = *++YYCURSOR;
			if (yych != 's') goto yy45;
			yych = *++YYCURSOR;
			if (yych != 'e') goto yy45;
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
yy69:
			yyaccept = 0;
			YYMARKER = ++YYCURSOR;
			yych = *YYCURSOR;
yy70:
			if (yybm[0+yych] & 64) {
				goto yy69;
			}
			if (yych <= 'D') {
				if (yych != '.') goto yy19;
			} else {
				if (yych <= 'E') goto yy72;
				if (yych == 'e') goto yy72;
				goto yy19;
			}
yy71:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy45;
			if (yych <= '9') goto yy77;
			goto yy45;
yy72:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych != '+') goto yy45;
			} else {
				if (yych <= '-') goto yy73;
				if (yych <= '/') goto yy45;
				if (yych <= '9') goto yy74;
				goto yy45;
			}
yy73:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy45;
			if (yych >= ':') goto yy45;
yy74:
			++YYCURSOR;
			yych = *YYCURSOR;
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy74;
yy76:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy77:
			yyaccept = 3;
			YYMARKER = ++YYCURSOR;
			yych = *YYCURSOR;
			if (yych <= 'D') {
				if (yych <= '/') goto yy76;
				if (yych <= '9') goto yy77;
				goto yy76;
			} else {
				if (yych <= 'E') goto yy72;
				if (yych == 'e') goto yy72;
				goto yy76;
			}
yy79:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy71;
				goto yy19;
			} else {
				if (yych <= 'E') goto yy72;
				if (yych == 'e') goto yy72;
				goto yy19;
			}
yy80:
			++YYCURSOR;
			yych = *YYCURSOR;
yy81:
			if (yybm[0+yych] & 128) {
				goto yy80;
			}
			goto yy7;
yy82:
			++YYCURSOR;
			yych = *YYCURSOR;
			goto yy7;
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		if (yych <= 0xDF) {
			if (yych <= '[') {
				if (yych <= 0x1F) goto yy85;
				if (yych == '"') goto yy89;
				goto yy87;
			} else {
				if (yych <= '\\') goto yy91;
				if (yych <= 0x7F) goto yy87;
				if (yych <= 0xC1) goto yy93;
				goto yy95;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xE0) goto yy96;
				if (yych <= 0xEC) goto yy97;
				if (yych <= 0xED) goto yy98;
				goto yy99;
			} else {
				if (yych <= 0xF0) goto yy100;
				if (yych <= 0xF3) goto yy101;
				if (yych <= 0xF4) goto yy102;
				goto yy93;
			}
		}
yy85:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy87:
		++YYCURSOR;
yy88:
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy89:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		ZSTR_VAL(str)[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_SET(STR_P2);
			PHP_JSON_CONDITION_GOTO(STR_P2);
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy91:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'e') {
			if (yych <= '/') {
				if (yych == '"') goto yy115;
				if (yych >= '/') goto yy115;
			} else {
				if (yych <= '\\') {
					if (yych >= '\\') goto yy115;
				} else {
					if (yych == 'b') goto yy115;
				}
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy115;
				if (yych == 'n') goto yy115;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy115;
				} else {
					if (yych <= 't') goto yy115;
					if (yych <= 'u') goto yy117;
				}
			}
		}
yy92:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy93:
		++YYCURSOR;
yy94:
		{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy95:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy94;
		if (yych <= 0xBF) goto yy106;
		goto yy94;
yy96:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy94;
		if (yych <= 0xBF) goto yy114;
		goto yy94;
yy97:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy94;
		if (yych <= 0xBF) goto yy113;
		goto yy94;
yy98:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy94;
		if (yych <= 0x9F) goto yy112;
		goto yy94;
yy99:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy94;
		if (yych <= 0xBF) goto yy111;
		goto yy94;
yy100:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy94;
		if (yych <= 0xBF) goto yy109;
		goto yy94;
yy101:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy94;
		if (yych <= 0xBF) goto yy107;
		goto yy94;
yy102:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy94;
		if (yych >= 0x90) goto yy94;
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy105;
yy104:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy92;
			} else {
				goto yy94;
			}
		} else {
			goto yy126;
		}
yy105:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych >= 0xC0) goto yy104;
yy106:
		yych = *++YYCURSOR;
		goto yy88;
yy107:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych >= 0xC0) goto yy104;
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy109:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych >= 0xC0) goto yy104;
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy111:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy112:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy113:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy114:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy104;
		if (yych <= 0xBF) goto yy106;
		goto yy104;
yy115:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy117:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy104;
				if (yych >= '1') goto yy119;
			} else {
				if (yych <= '@') goto yy104;
				if (yych <= 'C') goto yy119;
				goto yy120;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy119;
				if (yych <= '`') goto yy104;
				goto yy119;
			} else {
				if (yych <= 'd') goto yy120;
				if (yych <= 'f') goto yy119;
				goto yy104;
			}
		}
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy104;
			if (yych <= '0') goto yy139;
			if (yych <= '7') goto yy140;
			goto yy121;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy104;
				goto yy121;
			} else {
				if (yych <= '`') goto yy104;
				if (yych <= 'f') goto yy121;
				goto yy104;
			}
		}
yy119:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych <= '9') goto yy121;
			goto yy104;
		} else {
			if (yych <= 'F') goto yy121;
			if (yych <= '`') goto yy104;
			if (yych <= 'f') goto yy121;
			goto yy104;
		}
yy120:
		yych = *++YYCURSOR;
		if (yych <= 'B') {
			if (yych <= '7') {
				if (yych <= '/') goto yy104;
			} else {
				if (yych <= '9') goto yy122;
				if (yych <= '@') goto yy104;
				goto yy122;
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') goto yy123;
				goto yy104;
			} else {
				if (yych <= 'b') goto yy122;
				if (yych <= 'f') goto yy123;
				goto yy104;
			}
		}
yy121:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych <= '9') goto yy136;
			goto yy104;
		} else {
			if (yych <= 'F') goto yy136;
			if (yych <= '`') goto yy104;
			if (yych <= 'f') goto yy136;
			goto yy104;
		}
yy122:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych <= '9') goto yy127;
			goto yy104;
		} else {
			if (yych <= 'F') goto yy127;
			if (yych <= '`') goto yy104;
			if (yych <= 'f') goto yy127;
			goto yy104;
		}
yy123:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy124;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy124:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy125;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy125:
		++YYCURSOR;
yy126:
		{
		s->errcode = PHP_JSON_ERROR_UTF16;
		return PHP_JSON_T_ERROR;
	}
yy127:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy128;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy128:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy126;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy104;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy131;
		if (yych != 'd') goto yy104;
yy131:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy104;
		if (yych <= 'F') goto yy132;
		if (yych <= 'b') goto yy104;
		if (yych >= 'g') goto yy104;
yy132:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy133;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy133:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy134;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy134:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy136:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy137;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy137:
		++YYCURSOR;
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy139:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych <= '7') goto yy144;
			if (yych <= '9') goto yy141;
			goto yy104;
		} else {
			if (yych <= 'F') goto yy141;
			if (yych <= '`') goto yy104;
			if (yych <= 'f') goto yy141;
			goto yy104;
		}
yy140:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy141;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy141:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy142;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy142:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy144:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy104;
			if (yych >= ':') goto yy104;
		} else {
			if (yych <= 'F') goto yy145;
			if (yych <= '`') goto yy104;
			if (yych >= 'g') goto yy104;
		}
yy145:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2:
		yych = *YYCURSOR;
		if (yych == '"') goto yy151;
		if (yych == '\\') goto yy153;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2); }
yy151:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy153:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy155;
yy154:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';
				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy155:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy156;
				if (yych <= '0') goto yy157;
				goto yy158;
			} else {
				if (yych <= '@') goto yy156;
				if (yych <= 'C') goto yy158;
				goto yy159;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy158;
				if (yych >= 'a') goto yy158;
			} else {
				if (yych <= 'd') goto yy159;
				if (yych <= 'f') goto yy158;
			}
		}
yy156:
		YYCURSOR = YYMARKER;
		goto yy154;
yy157:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy156;
			if (yych <= '0') goto yy174;
			if (yych <= '7') goto yy175;
			goto yy161;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy156;
				goto yy161;
			} else {
				if (yych <= '`') goto yy156;
				if (yych <= 'f') goto yy161;
				goto yy156;
			}
		}
yy158:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych <= '9') goto yy161;
			goto yy156;
		} else {
			if (yych <= 'F') goto yy161;
			if (yych <= '`') goto yy156;
			if (yych <= 'f') goto yy161;
			goto yy156;
		}
yy159:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych <= '7') goto yy161;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'B') goto yy160;
			if (yych <= '`') goto yy156;
			if (yych >= 'c') goto yy156;
		}
yy160:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych <= '9') goto yy165;
			goto yy156;
		} else {
			if (yych <= 'F') goto yy165;
			if (yych <= '`') goto yy156;
			if (yych <= 'f') goto yy165;
			goto yy156;
		}
yy161:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy162;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy162:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy163;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy163:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy165:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy166;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy166:
		yych = *++YYCURSOR;
		if (yych != '\\') goto yy156;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy156;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy169;
		if (yych != 'd') goto yy156;
yy169:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy156;
		if (yych <= 'F') goto yy170;
		if (yych <= 'b') goto yy156;
		if (yych >= 'g') goto yy156;
yy170:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy171;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy171:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy172;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy172:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy174:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych <= '7') goto yy179;
			if (yych <= '9') goto yy176;
			goto yy156;
		} else {
			if (yych <= 'F') goto yy176;
			if (yych <= '`') goto yy156;
			if (yych <= 'f') goto yy176;
			goto yy156;
		}
yy175:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy176;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy176:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy177;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy177:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy179:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy156;
			if (yych >= ':') goto yy156;
		} else {
			if (yych <= 'F') goto yy180;
			if (yych <= '`') goto yy156;
			if (yych >= 'g') goto yy156;
		}
yy180:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
	}


}

