/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOptimized$class;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final double maxPreciseDouble;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<TimeUnit, String> timeUnitName;
    private final Map<String, TimeUnit> timeUnit;
    private final long \u00b5s_per_ns;
    private final long ms_per_ns;
    private final long s_per_ns;
    private final long min_per_ns;
    private final long h_per_ns;
    private final long d_per_ns;
    private final FiniteDuration Zero;
    private final Duration.Infinite Undefined;
    private final Duration.Infinite Inf;
    private final Duration.Infinite MinusInf;

    static {
        new Duration$();
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s2) {
        block8: {
            Duration duration;
            block6: {
                Duration duration2;
                String s1;
                block7: {
                    block5: {
                        Predef$ predef$ = Predef$.MODULE$;
                        s1 = (String)TraversableLike$class.filterNot(new StringOps(s2), (Function1)((Object)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(char x$1) {
                                Predef$ predef$ = Predef$.MODULE$;
                                return RichChar$.MODULE$.isWhitespace$extension(x$1);
                            }
                        }));
                        boolean bl = !("Inf" != null ? !"Inf".equals(s1) : s1 != null) ? true : (!("PlusInf" != null ? !"PlusInf".equals(s1) : s1 != null) ? true : !("+Inf" != null ? !"+Inf".equals(s1) : s1 != null));
                        if (!bl) break block5;
                        duration = this.Inf();
                        break block6;
                    }
                    boolean bl = !("MinusInf" != null ? !"MinusInf".equals(s1) : s1 != null) ? true : !("-Inf" != null ? !"-Inf".equals(s1) : s1 != null);
                    if (!bl) break block7;
                    duration = this.MinusInf();
                    break block6;
                }
                Predef$ predef$ = Predef$.MODULE$;
                String string2 = (String)IndexedSeqOptimized$class.reverse(new StringOps(s1));
                Predef$ predef$2 = Predef$.MODULE$;
                String string3 = (String)IndexedSeqOptimized$class.takeWhile(new StringOps(string2), (Function1)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$2) {
                        Predef$ predef$ = Predef$.MODULE$;
                        return RichChar$.MODULE$.isLetter$extension(x$2);
                    }
                }));
                Predef$ predef$3 = Predef$.MODULE$;
                String unitName = (String)IndexedSeqOptimized$class.reverse(new StringOps(string3));
                Option option = this.timeUnit().get(unitName);
                if (!(option instanceof Some)) break block8;
                Some some = (Some)option;
                Predef$ predef$4 = Predef$.MODULE$;
                String valueStr = (String)IndexedSeqOptimized$class.dropRight(new StringOps(s1), unitName.length());
                double valueD = Double.parseDouble(valueStr);
                if (valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15) {
                    duration2 = this.fromNanos((double)((TimeUnit)((Object)some.x())).toNanos(1L) * valueD);
                } else {
                    TimeUnit timeUnit = (TimeUnit)((Object)some.x());
                    long l = Long.parseLong(valueStr);
                    Duration$ duration$ = this;
                    duration2 = new FiniteDuration(l, timeUnit);
                }
                duration = duration2;
            }
            return duration;
        }
        throw new NumberFormatException(new StringBuilder().append((Object)"format error ").append((Object)s2).toString());
    }

    public List<String> scala$concurrent$duration$Duration$$words(String s2) {
        return Predef$.MODULE$.refArrayOps((Object[])s2.trim().split("\\s+")).toList();
    }

    public List<String> scala$concurrent$duration$Duration$$expandLabels(String labels) {
        List<String> list2 = this.scala$concurrent$duration$Duration$$words(labels);
        if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            Tuple2 tuple2 = new Tuple2($colon$colon.hd$1(), $colon$colon.tl$1());
            String hd = (String)tuple2._1();
            List<String> rest = tuple2._2();
            return rest.flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<String> apply(String s2) {
                    return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{s2, new StringBuilder().append((Object)s2).append((Object)"s").toString()}));
                }
            }, List$.MODULE$.canBuildFrom()).$colon$colon(hd);
        }
        throw new MatchError(list2);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return this.timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s2) {
        Option option;
        Option option2 = this.liftedTree1$1(s2);
        if (option2.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Duration duration = (Duration)option2.get();
            option = MODULE$.unapply(duration);
        }
        return option;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.isFinite() ? new Some<Tuple2<Long, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit())) : None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        Duration duration;
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            duration = nanos > 0.0 ? this.Inf() : this.MinusInf();
        } else if (Predef$.MODULE$.double2Double(nanos).isNaN()) {
            duration = this.Undefined();
        } else {
            if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"trying to construct too large duration with ").append(BoxesRunTime.boxToDouble(nanos)).append((Object)"ns").toString());
            }
            duration = this.fromNanos((long)(nanos + 0.5));
        }
        return duration;
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration.Infinite Undefined() {
        return this.Undefined;
    }

    public Duration.Infinite Inf() {
        return this.Inf;
    }

    public Duration.Infinite MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s2) {
        return this.apply(s2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option liftedTree1$1(String s$1) {
        Option option;
        try {
            option = new Some<Duration>(this.apply(s$1));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option;
    }

    private Duration$() {
        MODULE$ = this;
        Tuple2[] tuple2Array = new Tuple2[7];
        Predef$ predef$ = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[0] = new Tuple2<TimeUnit, String>(TimeUnit.DAYS, "d day");
        Predef$ predef$2 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$2 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[1] = new Tuple2<TimeUnit, String>(TimeUnit.HOURS, "h hour");
        Predef$ predef$3 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$3 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[2] = new Tuple2<TimeUnit, String>(TimeUnit.MINUTES, "min minute");
        Predef$ predef$4 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$4 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[3] = new Tuple2<TimeUnit, String>(TimeUnit.SECONDS, "s sec second");
        Predef$ predef$5 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$5 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[4] = new Tuple2<TimeUnit, String>(TimeUnit.MILLISECONDS, "ms milli millisecond");
        Predef$ predef$6 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$6 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[5] = new Tuple2<TimeUnit, String>(TimeUnit.MICROSECONDS, "\u00b5s micro microsecond");
        Predef$ predef$7 = Predef$.MODULE$;
        Predef$ArrowAssoc$ predef$ArrowAssoc$7 = Predef$ArrowAssoc$.MODULE$;
        tuple2Array[6] = new Tuple2<TimeUnit, String>(TimeUnit.NANOSECONDS, "ns nano nanosecond");
        this.timeUnitLabels = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.timeUnitName = this.timeUnitLabels.toMap(Predef$.MODULE$.conforms()).mapValues(new anonfun.3()).toMap(Predef$.MODULE$.conforms());
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap(new anonfun.4(), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        this.Undefined = new anon.1();
        this.Inf = new anon.2();
        this.MinusInf = new anon.3();
    }
}

