/**
 * @file
 * Provides a click handler for buttons in dropdown menus.
 */

(function ($) {
  "use strict";

  // Delegates links that are really "actions" (buttons) in the dropdown menu
  // to the actual button so it can actually submit the form.
  $(document).on('click', 'a[data-target="dropdown-button"]', function (e) {
    e.preventDefault();
    e.stopPropagation();
    $(this).parent().find('button').trigger('click');
  });

  // Handle buttons that used to be dropbutton links.
  // @see \Drupal\bootstrap\Plugin\Preprocess\BootstrapDropdown::preprocessLinks
  $(document).on('click', '.btn-group button[data-url], .dropdown button[data-url]', function (e) {
    var url = $(this).data('url');
    if (url) {
      e.preventDefault();
      e.stopPropagation();
      window.location = url;
    }
  });

})(jQuery);
